"use strict";

this.name = "Elite Trader";
this.author = "Reval";
this.description = "Almost a meta-game, the Guild of Elite Traders subverts Galcop and turns everything toward Trade. Services include anti-masslock, witchpoint refuel, a forever-clean record, constant ship-enhancement, fast dock; and Market scores count toward Elite. Progress in Grade brings a further edge. But - do not kill!";
this.license = "CC-BY-NC-SA 4.0";
this.version = "1.19a";

/* 
   Version 1.19
   ------------

   Version 1.18
   ------------
 * In spite of the addition of the new F4 page 'Gift to Guild' (which speeds advancement in Grade), progression to the Elevated and Exalted Grades (10-22) has been made more arduous.
 * Donations are no longer limited to one per system: they are cumulative within the system.
 * "Buber's Beats" Milk Run guide for inductees on the F4 Interfaces screen.
 * 'Milk or Cream? - Buber's Beats' - a comprehensive wiki section with solid guidance, a truncated version of which appears in-game.
 * Owing to a ballooning volume of Guild applications (blame TM!), the 'black box' anti-Masslock device is now reserved for Probationary Grade 1 and above.
 * Buying and selling from and to multiple stations insystem is facilitated.
 * More data now appears on the G.E.T. F5 Mission screen.
 * Gifts and Last trade (with star, station, and goods) added to F5 Mission screen.
 * Since space allows it, a station's secondary legal commodity is now listed by the F4 Master Advisory along with the primary.
 * Much revision of the F4 Interfaces texts.
 * More immersive comms messages geared to Grocers.
 * Witchpoint Trade Advisory messages made more succinct.
 * A slight re-ordering and renaming of the G.E.T. Grades.
		
 (Please see https://wiki.alioth.net/index.php/Elite_Trader_OXZ)
		 
*/

	
this.playerSoldCargo = function(commodity, units, price) {
	var sale = 0, tp = "", tm = "", c=commodity,
	prec = ((c=="gold")||(c=="platinum")||(c=="gem_stones"));
	// Guild sales are conditional upon...
	var cond = ((this.$etLastPrice[c]>0) && (!prec));
	// selling preliminaries - update quantity and price
	if (cond) {
		sale = price * units;
		// this sale's profit & total profit
		this.$etProfit = sale - this.$etLastBuy[c];
		// note the commodities sold
		if (this.$etProfit>0) this.$etCommodities += c + " ";
		// allow for multiple station trades insystem (TEST!)
		//this.$etLastProfit = this.$etTotProfit;
		this.$etTotProfit += this.$etProfit;
		// allow for multiple station trades insystem (TEST!)
		this.$etLastProfit = this.$etTotProfit;
		// prepare trade messages
		tp="   ( "+formatCredits(this.$etTotProfit/10,true,true)+" )";
		tm="Trade ("+c+"): "+formatCredits(this.$etProfit/10,true,true);
		/* max trade is calculated outside Market screen */
	}
	// see if we made a profit 
	this.$etMadeProfit = ((this.$etProfit>0) && (cond));

	// conditions for scoring
	this.$etOKtoScore = ((units > 2) && (!this.$etDone) && (this.$etBoughtUnits>0) && (this.$etMadeProfit) && (!this.$etIsBellig) && (!this.$etBeenBellig) && (!this.$etIsScooper));
	
	// decrement the manifest by # of units and price
	if (cond) {
		this.$etBoughtUnits -= units;
		this.$etBoughtPrice -= this.$etLastPrice[c] * units;
	}
	// display ship's cargo and its purchase value
	if ((price==this.$etLastPrice[c]) && (!prec)) this._etPodsInHold(this.$etBoughtUnits);	

	var pm = player.consoleMessage;
	// credit a "market killing" on first profitable sell
	if (this.$etOKtoScore) {
		player.score++;
		this.$etPoints++;
		this.$etHasScored = true;
		pm("You made a killing!"+tp);
		if (!this.$etMarketObserver) pm(tm);
		// for simplicity, only one score per station
		this.$etDone = true;
	// otherwise acknowledge a skillful trade if we're not just unloading
	} else if (this.$etMadeProfit && (price!=this.$etLastPrice[c]) && (this.$etStation!=this.$etLastStation)) {
		pm("Nice trade!"+tp);
		if (!this.$etMarketObserver) pm(tm);
	}
}
	

this.playerBoughtCargo = function (commodity, units, price) {
	var c=commodity,
	prec = ((c=="gold")||(c=="platinum")||(c=="gem_stones"));
	// buying preliminaries - record quantity and price
	if (!prec) {
		this.$etBoughtUnits += units;
		this.$etBoughtPrice += price * units;
		this.$etLastBuy[c] = price * units;
		this.$etLastPrice[c] = price;
		// display ship's cargo and its purchase value
		this._etPodsInHold(this.$etBoughtUnits);
	}
}


this.guiScreenChanged = function(to, from) {
	var pm = player.consoleMessage;
	// update G.E.T. Status on Manifest screen
	if (from == "GUI_SCREEN_MARKET") {
		// record last profit - for multiple station trades (TEST!)
		this.$etLastProfit=this.$etTotProfit;
		this._etGetMaxTrade();
		// deduct donation from player's credits
		if (this.$etProfit>0) {
			this.$etDonation = this._etGetDonation(this.$etTotProfit);
			if (this.$etDonation>0) {
				this.$etDonations += this.$etDonation;
				// donation is decicredits, so convert
				player.credits -= this.$etDonation/10; 
				pm("Your gift is accepted with appreciation.",5);
				pm("Advancement is secure!",5);
			}
		}
		// include donation in status report
		this._etShowStatus();
	} else
	if (to == "GUI_SCREEN_MARKET") {
		// reset local individual profit
		if (!this.$etCheat) this.$etProfit=0;
		// a G.E.T. presence on the market floor
		pm("The "+this.$etSystem+" Guild of Elite Traders", 5);
		// show hold-status on entering Market
		var pods = this._etPodCount();
		this._etPodsInHold(pods);
		// advise player to unload and re-buy cargo after game-load w/ full hold
		if ((pods>0) && (this.$etBoughtPrice<=0)) pm("Elite Trader: Please sell cargo and re-buy.",5); 
	} else
	if (to == "GUI_SCREEN_MANIFEST") {
		// show best trade status on Manifest screen
		this._etShowStatus();
		// G.E.T. presence on the Manifest screen
		pm("Under the aegis of the "+this.$etSystem+" G.E.T", 10);
	} else 
	if (to == "GUI_SCREEN_STATUS")
		if (!this.$etVowing) {
			if (this.$etIsWelcomed) {
				if (!this.$etMadeProfit)
					pm("We trust your stay at "+this.$etSystem+" proves profitable!", 10);
				else pm(this.$etSystem+" is your lucky star!", 10);
			} else {
				this._etSayWelcome();
				this.$etIsWelcomed = true;
			} 
		} else this.$etVowing = false;
}


this.shipDockedWithStation = function(station) {
	this.$etLastStation = this.$etStation;
	this.$etStation = station;
	this.$etLastSystem = this.$etSystem;
	// System's G.E.T. welcomes the commander on arrival
	this._etSayWelcome();
	// clear flags and sold-quantities on docking
	this.$etDone = false;
	this.$etMadeProfit = false;
	this.$etHasScored = false;
	this.$etProfit = 0;
	// total profit is reset at WP exit
	this.$etCommodities = "";
	// leave an identical ship at the shipyard
	// in case player wishes to reset its specs
	this._etCloneShip();
	if (!this.$etBeenBellig) {
		// prep G.E.T. Advsory interface
		this._etPrepAdvisory(station);
		// prep G.E.T. Max Trade Resetter
		this._etPrepResetter(station);
		// prep G.E.T. Ship Status Report
		this._etPrepShipStatus(station);
		// prep G.E.T. Gift to Guild
		this._etPrepGift(station);
		// prep walkthrough
		this._etPrepBeats (station);
		// prep gender if not yet known
		if (!this.$etGendered)
			this._etPrepGender(station);
	} else this._etPrepVow(station);
	// generate G.E.T. contact name (Assessor)
	this.$etContact = randomName() + " " + randomName();
}


this.shipWillDockWithStation = function(station) {
	// refuel a good Brother's ship gratis
	var f="", p=player.ship, pa=player.addMessageToArrivalReport;
	if ((p.fuel<7) && (!this.$etIsBellig) && (!this.$etBeenBellig)) {
		p.fuel = 7;
		f = "refuelled and "; }
	// if the Brother's recent trades were satisfactory...
	if (this.$etHasScored) {
		// a personal welcome from the local Guild Master
		pa("The "+this.$etSystem+" Guild of Elite Traders bids their "+this.$etBro+" "+player.name+" a hearty welcome to their Guild Home and trusts this sojourn among us will be advantageous...");
		pa("Trade well! May the GETTING exceed the Taking!");
		// service the Brother's ship if its condition is under par
		if ((p.serviceLevel<100) || (f!="")) {
			p.serviceLevel = 100;
			pa("Our Brother mechanic now reports that your craft is "+f+"in good repair. Fair voyage when you leave us, and return soon!");
		}
		// incremental protective enhancements for the Brother's ship
		if (this.$etLastSpeed<this.$etLimitSpeed) {
			p.maxSpeed++;
			// check
			var spd = p.maxSpeed;
		}
		if (this.$etLastThrust<this.$etLimitThrust) {
			p.maxThrust++;
		}
		if (this.$etLastShields<this.$etLimitShields) {
			p.maxForwardShield++;
			p.maxAftShield++;
		}
		if (this.$etLastEnergy<this.$etLimitEnergy) {
			p.maxEnergy++;
		}
		if (this.$etLastRecharge<this.$etLimitRecharge) {
			p.forwardShieldRechargeRate+=0.05;
			p.aftShieldRechargeRate+=0.05;
		}
		if (this.$etLastERecharge<this.$etLimitERecharge) {
			p.energyRechargeRate+=0.1;
		}
		pa("Our G.E.T. Brother adept has used an ages-lost and arcane technique to increase the capacity of your shields and your ship's speed by a small factor, that your passages in and out of our system might be a little safer.");
		if (spd!=this.$etLastSpeed) pa("Previous speed: "+this.$etLastSpeed+";  Revised speed: "+p.maxSpeed);
		pa("Previous energy: "+this.$etLastEnergy+";  Revised energy: "+p.maxEnergy);
		pa("Previous recharge: "+this.$etLastERecharge.toFixed(2)+";  Revised recharge: "+p.energyRechargeRate.toFixed(2));
		// update last specs after report
		this.$etLastSpeed=p.maxSpeed;
		this.$etLastThrust=p.maxThrust;
		this.$etLastShields=p.maxForwardShield;
		this.$etLastEnergy=p.maxEnergy;
		this.$etLastRecharge=p.forwardShieldRechargeRate;
		this.$etLastERecharge=p.energyRechargeRate;
		// remove fast-docking equipment
		p.removeEquipment("EQ_ET_AUTODOCK");
		// reset station profit
		this.$etLastProfit=0;
	}
}


this.shipWillLaunchFromStation = function(station) {
	// G.E.T. ensures the good Brother's record is always clean
	if ((!this.$etIsBellig) && (!this.$etBeenBellig)) {
		player.ship.bounty = 0;
		// enable fast docking
		this._installAutoDock();
	}
}


this.shipLaunchedFromStation = function(stationLaunchedFrom) {
	if (!this.$etBeenBellig)
		player.commsMessage("The "+this.$etSystem+" G.E.T. Aegis wishes you clear lanes and a quiet passage. Return safe!", 6);
	// weapons offline is the G.E.T. approved setting
	//player.ship.weaponsOnline = false; // doesn't appear to be writable
}


this.playerStartedJumpCountdown = function(type, seconds) {
	if (!this.$etBeenBellig)
		player.commsMessage("Be careful out among the miscreants "+this.$etBro+"!",6);
	if ((!this.$etIsBellig) && (!this.$etBeenBellig) && (!this.$etIsScooper) && (!player.ship.weaponsOnline)) player.ship.massLockable = this._etStrict();
}


this.shipEnteredStationAegis = function(station) {
	if (!this.$etBeenBellig)
		player.commsMessage("The Galactic Guild of Elite Traders welcomes you to "+this.$etSystem+" Aegis! We are at your disposal in the shipyard. Trade well!", 6);
	player.ship.massLockable = this._etStrict(); // true: no slamming into station
}


this.weaponsSystemsToggled = function(state) {
	// Strict mode for Grade 0, or not...
	if (this._etStrict()) {
		player.ship.massLockable = true;
		player.commsMessage(this.$etBro+", Grade 1 must be attained...",9);
		player.commsMessage("Please take care off-lane.",9);
	} else {
		// weapons online enables mass-locking
		player.ship.massLockable = state;
		if (state) var s="OFF"; else var s="ON";
		player.commsMessage("Anti-masslock system "+s);
	}
}


this.shipKilledOther = function(whom, damageType) {
	 // discount tins of SPAM and rocks
	 if ((whom.name!="SPAM") && (whom.name!="Asteroid")) {
		pm = player.commsMessage;
		// G.E.T. disapproval
		pm(this.$etSystem+" G.E.T. notes their Brother's lapse...");
		this.$etKillCount++;
		this.$etIsBellig = (this.$etKillCount>0); // temporary
		// a single kill might be accidental, but 3? - unlikely!
		if (this.$etKillCount>2) { 
			this.$etBeenBellig = true; // permanent - a blot on the record
			this._etFloorSpecs(); // ship specs back to nominal
			// refund donations
			player.credits += this.$etDonations/10;
			// and reset them
			this.$etDonations = 0.0;
			pm("Your gifts to the Guild have been returned.");
			pm("All G.E.T. privileges are rescinded.");
			pm("Vow to be a better Brother!");
		}
	}
}


this.shipScoopedOther = function(whom) {
     // G.E.T. disapproval
	player.commsMessage(this.$etSystem+" G.E.T. notes their Brother's lapse...");
	this.$etIsScooper = true;
}


this.shipEnteredPlanetaryVicinity = function(planet) {
	player.commsMessage("Entering gravity of "+this._etGetPlanetName(planet));
	// Weps will always masslock near planets
	if (player.ship.weaponsOnline) player.ship.massLockable = this._etStrict(); // no slamming into planet
}


this.shipExitedPlanetaryVicinity = function(planet) {
	player.commsMessage("Leaving gravity of "+this._etGetPlanetName(planet));
	if ((!this.$etIsBellig) && (!this.$etBeenBellig) && (!this.$etIsScooper) && (!player.ship.weaponsOnline)) player.ship.massLockable = this._etStrict();
}


this.shipExitedWitchspace = function() {
	this.$etSystem = System.systemNameForID(system.ID);
	this.$etIsWelcomed = false;
	if (this.$etKillCount>0) this.$etKillCount--;
	this.$etIsBellig = (this.$etKillCount>0);
	this.$etIsScooper = false;
	// total profit is for system
	this.$etTotProfit = 0;
	// (reset) for multiple station trades
	this.$etLastProfit = 0;
	this._etGetMaxTrade();
	// one donation and gift per system
	this.$etDonated = false;
	this.$etGifted = false;
	// no-skip in Grade check (reset for system)
	this.$etLastGrade = 0;
	// build G.E.T. status screen
	this._etShowStatus();
	// witchpoint fuelling for GBs past probation
	var p=player.ship, pc=player.commsMessage;
	if ((!this.$etIsBellig) && (!this.$etBeenBellig) 
		&& (!p.weaponsOnline) && (this._etGetGrade()>1)) {
		p.fuel = 7;
		pc(""); // LF
		pc("Witchpoint fuelling complete.");
		pc(this.$etSystem+" G.E.T. wishes their "+this.$etBro+" a peaceful jump.");
		// witchpoint Trade Advisory (where to sell)
		this._etCommsTradeAdvisory();
	}
	// advice for Grocers
	if (this._etStrict()) pc(this.$etBro+" Grocer, go off-lane... be safe!");
	// increment number of sys-to-sys runs
	this.$etRuns+=1;
}


this.playerBoughtNewShip = function(ship, price) {
	// spec globals to ship's initial values
	this._etResetSpecs();
	this.$etShipChanged = true;
	this._etGetMaxTrade();
	this._etShowStatus();
}


this.playerWillSaveGame = function(message) {
	missionVariables.etSpeed = this.$etLastSpeed;
	missionVariables.etThrust = this.$etLastThrust;
	missionVariables.etEnergy = this.$etLastEnergy;
	missionVariables.etShields = this.$etLastShields;
	missionVariables.etRecharge = this.$etLastRecharge;
	missionVariables.etERecharge = this.$etLastERecharge;
	missionVariables.etPoints = this.$etPoints;
	missionVariables.etKills = this.$etKillCount;
	missionVariables.etMaxTrade = this.$etMaxTrade;
	missionVariables.etMinTrade = this.$etMinTrade;
	missionVariables.etMaxTSystem = this.$etMaxTSystem;
	missionVariables.etMaxTGoods = this.$etMaxTGoods;
	missionVariables.etMaxTShip = this.$etMaxTShip;
	missionVariables.etMaxTShipName = this.$etMaxTShipName;
	missionVariables.etMaxTShipTC = this.$etMaxTShipTC;
	missionVariables.etVowCount = this.$etVowCount;
	missionVariables.etDonations = this.$etDonations;
	missionVariables.etGifts = this.$etGifts;
	missionVariables.etGiftCount = this.$etGiftCount;
	missionVariables.etGendered = this.$etGendered;
	missionVariables.etBro = this.$etBro; // gender!
	missionVariables.etRuns = this.$etRuns;
	missionVariables.etYears = this.$etYears;
	missionVariables.etDays = this.$etDays;
	missionVariables.etDaysStart = this.$etDaysStart; // set only once in script!
	missionVariables.etBonuses = this.$etBonuses;
	// cannot save booleans as "false/true" - must convert
	// set only once at Guilder career start
	if (this.$etDaysStarted) var dstd=1; else var dstd=0;
	missionVariables.etDaysStarted = dstd;
	// cannot save booleans as "false/true" - must convert
	if (this.$etGendered) var gen=1; else var gen=0;
	missionVariables.etGendered = gen;
	// cannot save booleans as "false/true" - must convert
	if (this.$etStrict) var strct=1; else var strct=0;
	missionVariables.etStrict = strct;
	// cannot save booleans as "false/true" - must convert
	if (this.$etBeenBellig) var bb=1; else var bb=0;
	missionVariables.etBeenBellig = bb;
}


this.startUpComplete = function () {
	var p = player.ship;
	this.$etSystem = System.systemNameForID(system.ID);
	this._etResetSpecs();
	// default is current ship
	this.$etMaxTShip = p.shipClassName;
	this.$etMaxTShipName = p.shipUniqueName;
	this.$etMaxTShipTC = p.cargoSpaceCapacity;
	// Load saved globals, if present
	var spd = missionVariables.etSpeed;
	var thr = missionVariables.etThrust;
	var ene = missionVariables.etEnergy;
	var shi = missionVariables.etShields;
	var rec = missionVariables.etRecharge;
	var rece = missionVariables.etERecharge;
	
	if (spd>=this.$etInitialSpeed) this.$etLastSpeed = spd;
	if (thr>=this.$etInitialThrust) this.$etLastThrust = thr;
	if (ene>=this.$etInitialEnergy) this.$etLastEnergy = ene;
	if (shi>=this.$etInitialShields) this.$etLastShields = shi;
	if (rec>=this.$etInitialRecharge) this.$etLastRecharge = rec;
	if (rece>=this.$etInitialERecharge) this.$etLastERecharge = rece;
	
	if (spd>=this.$etInitialSpeed) p.maxSpeed = spd;
	if (thr>=this.$etInitialThrust) p.maxThrust = thr;
	if (ene>=this.$etInitialEnergy) p.maxEnergy = ene;
	if (shi>=this.$etInitialShields) p.maxForwardShield = shi;
	if (rec>=this.$etInitialRecharge) p.forwardShieldRechargeRate = rec;
	if (rece>=this.$etInitialERecharge) p.energyRechargeRate = rece;
	// load points here too
	var pts = missionVariables.etPoints; if (pts>0) this.$etPoints = pts;
	var kil = missionVariables.etKills; if (kil>0) this.$etKillCount = kil; 
	var maxt = missionVariables.etMaxTrade; this.$etMaxTrade = maxt;
	var mint = missionVariables.etMinTrade; this.$etMinTrade = mint;
	var maxts = missionVariables.etMaxTSystem; this.$etMaxTSystem = maxts;
	var maxtg = missionVariables.etMaxTGoods; this.$etMaxTGoods = maxtg;
	var maxts = missionVariables.etMaxTShip; if (maxts!="") this.$etMaxTShip = maxts;
	var maxtn = missionVariables.etMaxTShipName; if (maxtn!="") this.$etMaxTShipName = maxtn;
	var maxtt = missionVariables.etMaxTShipTC; if (maxtt!=0) this.$etMaxTShipTC = maxtt;
	var vc = missionVariables.etVowCount; if (vc!=null) this.$etVowCount = vc;
	var dons = missionVariables.etDonations; if (dons!=null) this.$etDonations = dons;
	var gifts = missionVariables.etGifts; if (gifts!=null) this.$etGifts = gifts;
	var gcount = missionVariables.etGiftCount; if (gcount!=null) this.$etGiftCount=gcount;
	var bro = missionVariables.etBro; if (bro!=null) this.$etBro = bro;
	var runs = missionVariables.etRuns; if (runs!=null) this.$etRuns = runs;
	var yrs = missionVariables.etYears; if (yrs!=null) this.$etYears = yrs;
	var days = missionVariables.etDays; if (days!=null) this.$etDays = days;
	var dayst = missionVariables.etDaysStart; if (dayst!=null) this.$etDaysStart = dayst;
	var bons = missionVariables.etBonuses; if (bons!=null) this.$etBonuses = bons;
	// have we started the clock? - permanent and persistent
	if (missionVariables.etDaysStarted != null) {
		var dstd=missionVariables.etDaysStarted;
		this.$etDaysStarted = (dstd == 1);
	}
	// cannot load booleans as "true/false" - must convert
	if (missionVariables.etBeenBellig != null) {
		var bb=missionVariables.etBeenBellig;
		this.$etBeenBellig = (bb == 1);
		// floor ship specs if the Brother went bad
		if (this.$etBeenBellig) this._etFloorSpecs();
	}
	// waive or allow Grade 0 strictures
	if (missionVariables.etStrict != null) {
		var strct=missionVariables.etStrict;
		this.$etStrict = (strct == 1);
	}
	// Gender-check (persistent)
	if (missionVariables.etGendered != null) {
		var gen=missionVariables.etGendered;
		this.$etGendered = (gen == 1);
	}
	// loading globals complete.
	if (this._etHasFE()) log(this.name, "finds FE Ships present ("+p.shipClassName+")");
	// dock ship
	var sta = p.dockedStation;
	this.shipDockedWithStation(sta);
	//this._etSayWelcome();
	this._etGetMaxTrade();
	this._etShowStatus();
	if (!this.$etBeenBellig) {
		// prep G.E.T. Advisory interface
		this._etPrepAdvisory(sta);
		// prep G.E.T. Max Trade Resetter
		this._etPrepResetter(sta);
		// prep G.E.T. Ship Status Report
		this._etPrepShipStatus(sta);
		// prep Gift solicitation
		this._etPrepGift (sta);
		// prep walkthrough
		this._etPrepBeats (sta);
		// conditionally, prep gender request
		if (!this.$etGendered) this._etPrepGender(sta);
	} else this._etPrepVow(sta);
	// set Grade Advance divisor according to present Grade
	var grade=this._etGetGrade();
	this._etSetGradeAdvance(grade);
	// determine strictness (anti-masslock on or off)
	this.$etStrict = this._etStrict();
	// start the career clock if not already started
	if (!this.$etDaysStarted) { 
		this.$etDaysStart = clock.days;
		this.$etDaysStarted = true;
	}
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// declare & initialize globals
	this.$etMarketObserver = false;
	if (worldScripts["market_observer3"]) 
		this.$etMarketObserver = true;
	this.$etDone = false;
	this.$etMadeProfit = false;
	this.$etOKtoScore = false;
	this.$etHasScored = false;
	this.$etIsWelcomed = false;
	this.$etShipChanged = false;
	this.$etIsScooper = false;
	this.$etIsBellig = false; // temporary
	this.$etBeenBellig = false; // permanent
	this.$etDonated = false;
	this.$etGifted = false;
	this.$etKillCount = 0; // ship-kills
	this.$etPoints = 0; // G.E.T. Elite-points scored
	this.$etVowCount = 0;
	this.$etVowing = false; // controls post-vow message
	this.$etBoughtPrice = 0;
	this.$etBoughtUnits = 0;
	this.$etProfit = 0;
	this.$etTotProfit = 0;
	this.$etLastProfit = 0; // for multiple station trades insystem
	this.$etMaxTrade = 0;
	this.$etMinTrade = 1000000;
	this.$etDonation = 0.0; // donation on station profit
	this.$etDonations = 0.0; // total 'donations' to G.E.T.
	this.$etGift = 0.0; // 'gift' (voluntary) of station profit
	this.$etGifts = 0.0; // total 'gifts' to Guild coffers
	this.$etGiftCount= 0; // how many gifts we've given
	this.$etStrict=true; // waive or allow Grade 0 stricture
	this.$etLastGrade=0; // for Grade no-skip check
	this.$etSystem = "";
	this.$etLastSystem = "";
	this.$etNextSystem = "";
	this.$etContact = ""; // named station contact (Assessor)
	this.$etCommodities = ""; // commodities sold
	this.$etMaxTSystem = ""; // best trade's systen
	this.$etMaxTGoods = ""; // best trade's commodity
	this.$etMaxTShip = ""; // best trade's ship class
	this.$etMaxTShipName = ""; // best trade's ship name
	this.$etMaxTShipTC = 0; // best trade's ship tonnage
	this.$etStation = new Object(); // ??
	this.$etLastStation = new Object(); // ??
	this.$etLastPrice = new Array();
	for (var c=0; c<20; c++) this.$etLastPrice[c]=0;
	this.$etLastBuy = new Array();
	for (c=0; c<20; c++) this.$etLastBuy[c]=0;
	
	this.$etInitialSpeed = 0;
	this.$etInitialThrust = 0;
	this.$etInitialEnergy = 0;
	this.$etInitialShields = 0;
	this.$etInitialRecharge = 0.0; // shields recharge
	this.$etInitialERecharge = 0.0; // energy recharge

	this.$etLastSpeed = 0;
	this.$etLastThrust = 0;
	this.$etLastEnergy = 0;
	this.$etLastShields = 0;
	this.$etLastRecharge = 0.0;
	this.$etLastERecharge = 0.0;
	
	// constants
	this.$etLimitSpeed = 512;
	this.$etLimitThrust = 256;
	this.$etLimitEnergy = 1024;
	this.$etLimitShields = 512;
	this.$etLimitRecharge = 16.0; // shield-R should be half energy-R
	this.$etLimitERecharge = 32.0; 
	
	this.$etGradeAdvance = 100000; // default 100000 (10,000 cr)
	
	// G.E.T. Grade Titles
	this.$etGETTitle = [
	"Grocer",
	"Entered Apprentice",
	"Fellowcrafter",
	"Master Trader",
	"Master Traveller",
	"Perfect Master",
	"Master of the Brazen Serpent",
	"Provost and Judge",
	"Intendant of the Orbital",
	"Master of the Guild House",
	"Master Elect",
	"Sublime Master Elected",
	"Master of Mercy", 
	"Master of the Ninth Arch",
	"Grand Elect Master",
	"Knight of the East",
	"Knight of the East and West",
	"Knight of the Rosy Star",
	"Friend and Brother Eternal",
	"Prince of Inera",
	"Sublime Keeper of the Galactic Secret", 
	"Grand Master Supreme, Serene and Sublime",
	"Elite Grand Master Everlasting"
	];
	// Roman numerals for planet nomenclature
	this.$etRoman = ["","I","II","III","IV","V","VI","VII","VIII","IX","X"];
	// Industrial and Agricultural products
	this.$etIGoods = ["computers","firearms","machinery","luxuries","alloys"];
	this.$etAGoods = ["furs","liquor_wines","radioactives","slaves","minerals","textiles","food"];
	this.$etCheat = false; // toggle 'hidden feature' for testing - default OFF
	// Brother or Sister?
	this.$etBro = "Guilder"; // switchable to "Sister", "Brother", or "Sibling"
	this.$etGendered = false; // true once imparted
	// number of system-to-system runs
	this.$etRuns = 0;
	// number of years as a Guilder
	this.$etYears = 0.0; // years passed since induction
	// constant: days in Lave Year - can (should?) be adjusted up/down
	this.$etLaveYear = 365;
	// days as a Guilder
	this.$etDays = 0; // days passed since G.E.T. induction
	this.$etDaysStart = 2084004; // day(s) _at_ G.E.T. induction
	this.$etDaysStarted = false; // have we started the G.E.T. clock?
	// total time or runs bonuses paid by G.E.T.
	this.$etBonuses = 0.0;
}


// are we being strict? (grade-dependent)
this._etStrict = function() {
	var strict = (this._etGetGrade() < 1);
	this.$etStrict = strict;
	return strict;
}


// obtain the G.E.T. numeric grade (from total donation)
this._etGetGrade = function() {
	var grade = 0;
	var lim=this.$etGETTitle.length-1;
	var don = this.$etDonations.toFixed(0); // use parseInt()?
	// set Grade Advance according to present grade
	grade = (don/this.$etGradeAdvance);
	grade = grade.toFixed(0); // use parseInt()?
	if (grade>lim) grade=lim;
	return grade;
}


// set grade advance divisor according to present Grade
this._etSetGradeAdvance = function(grade) {
	if (grade<6)  this.$etGradeAdvance = 100000; else
	if (grade<13) this.$etGradeAdvance = 150000; else
	if (grade<18) this.$etGradeAdvance = 200000; else
	if (grade<20) this.$etGradeAdvance = 300000; else
	if (grade<23) this.$etGradeAdvance = 400000; 
}


// # of cargo pods in ship's hold
this._etPodCount = function() {
	var result = 0, man=manifest.list;
	for (var i=0; i<man.length; i++) {
		var q = man[i].quantity;
		if (q > 0) result+= q;
	}	
	return result;
}


// is FE Ships Player installed?
this._etHasFE = function() {
	var str = player.ship.shipClassName;
	var n = str.search(" FE");
	return (n>-1);
}


// leave an identical ship at the shipyard
// in case player wishes to reset its specs
this._etCloneShip = function() {
	if (oolite.versionString>"1.88") {
		var pr = player.ship.price * 0.75;
		system.mainStation.addShipToShipyard({ 
			short_description: "G.E.T. offers you this clone of your ship, to reset our augmented specs to nominal, should you desire a clean break.", 
			shipdata_key: player.ship.dataKey, 
			price: pr, 
			personality:0,
			extras:[""]
		});
	}
}


// Brother's profit-donation to G.E.T
// * in decicredits *
this._etGetDonation = function(profit) {
	var donation = 0.0;
	if (!this.$etDonated) {
		if (profit>100.0) // > 10.0 cr
			// profit > 100 cr = 1% donation
			if (profit<=10000.0) { // <= 1000.0 cr
			donation = profit * 0.01;
			// proft > 1000 cr = 10% donation
			} else donation = profit * 0.1;
	}
	return donation;
}


// Brother's running max/min trades and commodities
this._etGetMaxTrade = function() {
	if (this.$etTotProfit>this.$etMaxTrade) {
		this.$etMaxTrade=this.$etTotProfit;
		this.$etMaxTSystem=this.$etSystem;		
		this.$etMaxTGoods=this.$etCommodities;		
		// the ship we maxed it in
		var p = player.ship;
		this.$etMaxTShip = p.shipClassName;
		this.$etMaxTShipName = p.shipUniqueName;
		this.$etMaxTShipTC = p.cargoSpaceCapacity;
	}
	if (this.$etTotProfit<this.$etMinTrade) this.$etMinTrade=this.$etTotProfit;
}


// Brother's standing, best trade, today's profit, donations etc --> Manifest
this._etShowStatus = function() { 
	if (this.$etBeenBellig) var br = "Bad"; else
	if (this.$etIsBellig) var br = "Errant"; else
	if (this.$etVowCount>0) var br = "Reformed"; else
		var br = "Good"; 
		var bro = this.$etBro; // gender!
	var pn = player.name;
	var statusBrother = br+" "+bro+" "+pn+", with "+formatCredits(player.credits, true, true);
	// days or years as a Guilder
	var dg = this._etGetDays(); // this.$etDays-this.$etDaysStart; 
	var yg=this._etGetYears();
	var statusTime = "Time as a "+bro+": "+dg+" Lave days ("+yg+" LY)";
	// number of runs as a Guilder
	var runs=player.score;
	if (this.$etRuns<=0) runs = player.score; 
		else runs=this.$etRuns; // (best guess or # of runs)  
	this.$etRuns = runs; // set here each time - belt'n'braces
	var statusRuns = "System-to-System Runs: "+runs; //this.$etRuns;
	// most profitable trade so far
	var statusTrade = "Best trade: " + formatCredits(this.$etMaxTrade/10, true, true ) + " (" + this.$etMaxTSystem + " - "+this.$etMaxTGoods+")";
	// ship + tonnage in which best trade was made
	var sn = this.$etMaxTShipName; 
	if ((sn=="") || (sn==null)) sn = ""; else sn=" '"+this.$etMaxTShipName+"'"; 
	var statusShip = "Ship: "+this.$etMaxTShip+sn+" ("+this.$etMaxTShipTC+" TC)";
	// present orbital (station)
	var ps=player.ship, po="none";
	if (ps.dockedStation!=null) po=ps.dockedStation.displayName; 
	var statusOrb = "Orbit: " + this.$etSystem +" "+po; 
	// last market trade
	var lp = this.$etLastProfit/10;
	var statusLastt = "Last trade: "+formatCredits(lp,true,true)+" ("+this.$etSystem+" "+po+" - "+this.$etCommodities+")";
	// total profit this system (so far)
	// allow for multiple market & station trades insystem
	// (may not be the best method, but the simplest)
	if (this.$etLastProfit != this.$etTotProfit) this.$etTotProfit += this.$etLastProfit;
	var tp = this.$etTotProfit/10;
	var profitTotal = "Profit here: "+formatCredits(tp,true,true);
	// time bonuses paid by G.E.T. to Guilder [DUMMY]
	this.$etBonuses = this._etGetYBonus();
	var statusBonus = "Bonuses received: " + this.$etBonuses;
	// donation this station
	var don = this.$etDonation/10; 
	var statusDonation = "Donation here: "+formatCredits(don,true,true);
	// total donations as cr
	var dons = this.$etDonations/10;
	var statusDonations = "Donations & Gifts: "+formatCredits(dons,true,true);
	// Gifts
	var gifts = this.$etGifts/10; 
	var gc=this.$etGiftCount;
	var statusGifts = "Gifts: "+formatCredits(gifts,true,true)+" ("+gc+")";
	// G.E.T. Grade and Title
	var grade = this._etGetGrade();
	// set Grade Advance divisor according to present Grade
	this._etSetGradeAdvance(grade);
	// no skip in Grade 
	// $etLastGrade is set on the Gift interface, otherwise it's 0
	if ((grade>this.$etLastGrade+1) && (this.$etLastGrade>0)) grade=this.$etLastGrade+1;
	var statusGrade = "Grade "+grade;
	var title = this.$etGETTitle[grade];
	statusGrade += ": "+title;
	// display the G.E.T. Status Report
	mission.setInstructions(["G.E.T. Status:",statusBrother,statusTime,statusRuns,statusOrb,statusTrade,statusShip,statusLastt,profitTotal,statusBonus,statusDonation,statusDonations,statusGifts,statusGrade], this.name);
}


// enhance ship by <points> points
this._etEnhanceShip = function(points) {
	var p = player.ship;
	// incremental defensive enhancements for the Guilder's ship
	if (this.$etLastSpeed<this.$etLimitSpeed) {
		p.maxSpeed+=points;
		// check
		var spd = p.maxSpeed;
		}
		if (this.$etLastThrust<this.$etLimitThrust) {
			p.maxThrust+=points;
		}
		if (this.$etLastShields<this.$etLimitShields) {
			p.maxForwardShield+=points;
			p.maxAftShield+=points;
		}
		if (this.$etLastEnergy<this.$etLimitEnergy) {
			p.maxEnergy+=points;
		}
		if (this.$etLastRecharge<this.$etLimitRecharge) {
			p.forwardShieldRechargeRate+=(points*0.05);
			p.aftShieldRechargeRate+=(points*0.05);
		}
		if (this.$etLastERecharge<this.$etLimitERecharge) {
			p.energyRechargeRate+=(points*0.1);
		}
		// update last specs after increments
		this.$etLastSpeed=p.maxSpeed;
		this.$etLastThrust=p.maxThrust;
		this.$etLastShields=p.maxForwardShield;
		this.$etLastEnergy=p.maxEnergy;
		this.$etLastRecharge=p.forwardShieldRechargeRate;
		this.$etLastERecharge=p.energyRechargeRate;
}


// nullify ship enhancements, setting specs to nominal
this._etFloorSpecs = function() {
	var p = player.ship;
	this.$etLastSpeed = this.$etInitialSpeed;
	this.$etLastThrust = this.$etInitialThrust;
	this.$etLastShields = this.$etInitialShields;
	this.$etLastEnergy = this.$etInitialEnergy;
	this.$etLastRecharge = this.$etInitialRecharge;
	this.$etLastERecharge = this.$etInitialERecharge;

	p.maxSpeed = this.$etInitialSpeed;
	p.maxThrust = this.$etInitialThrust;
	p.maxForwardShield = this.$etInitialShields;
	p.maxAftShield = this.$etInitialShields;
	p.maxEnergy = this.$etInitialEnergy;
	p.forwardShieldRechargeRate = this.$etInitialRecharge;
	p.aftShieldRechargeRate = this.$etInitialRecharge;
	p.energyRechargeRate = this.$etInitialERecharge;
}


this._etResetSpecs = function() {
	var p = player.ship;
	this.$etLastSpeed = p.maxSpeed;
	this.$etLastThrust = p.maxThrust;
	this.$etLastShields = p.maxForwardShield;
	this.$etLastEnergy = p.maxEnergy;
	this.$etLastRecharge = p.forwardShieldRechargeRate;
	this.$etLastERecharge = p.energyRechargeRate;
	// note ship's initial specs (for later comparisons)
	this.$etInitialSpeed = p.maxSpeed;
	this.$etInitialThrust = p.maxThrust;
	this.$etInitialShields = p.maxForwardShield;
	this.$etInitialEnergy = p.maxEnergy;
	this.$etInitialRecharge = p.forwardShieldRechargeRate;
	this.$etInitialERecharge = p.energyRechargeRate;
}


this._installAutoDock = function() {
	var p = player.ship;
	// give the non-straying Brother free fast-docking capability
	if (!this.$etIsBellig) {
		if (p.equipmentStatus("EQ_DOCK_COMP") != "EQUIPMENT_OK") {
			p.awardEquipment("EQ_ET_AUTODOCK");
		}
	}
}


this._etSayWelcome = function() {
	if (!this.$etBeenBellig)
		player.consoleMessage("The "+this.$etSystem+" Guild of Elite Traders welcomes you!", 5);
	if (!this.$etGendered)
		player.consoleMessage("Guilder, please hit F4 to impart your gender...", 9);
	if (this.$etRuns<=4) {
		player.consoleMessage("Please check your F4 G.E.T. Interfaces often!",9);
		player.consoleMessage("Always check the F5-F5 Manifest on ending trading!",9);
		player.consoleMessage("Go to F4 Interface to register Name and Ship.",9);
	}
}


// display ship's cargo and its purchase value
this._etPodsInHold = function(pods) {
	player.consoleMessage("In hold: "+pods+" pods ( "+formatCredits(((this.$etBoughtPrice)/10),true,true)+" )");
}


// planet name & number by 'compare radius' method
this._etGetPlanetName = function(plan) {
	var p=system.planets, name="",
	rad = plan.radius;
	if (rad!=null) {
		// run through planets in system...
		for (var i=0; i<p.length; i++) {
			if (i>0) {
				// if radii match, it's probably our planet
				if (rad===p[i].radius) name=p[i].name+" "+this.$etRoman[i+1];
			} else name=plan.name; // planet 0 is 'Prime'
		}
	} else name = plan.name; // 'vanilla' name
	return name;
}


this._etCommsTradeAdvisory = function() {
	// prices of system's key goods, plus quantity
	var ind = (system.economy<4), s=system.stations,
	pm = player.commsMessage;
	pm(""); // LF
	if (!ind) {
			for (var i=0; i<s.length; i++) if (s[i].name!="Rock Hermit")
				pm(s[i].name + ": Computers @ " + this._etMarketPrice(s[i],"computers") + " (" + this._etMarketQuantity(s[i],"computers") + ")",10);
		} else {
			for (var i=0; i<s.length; i++) if (s[i].name!="Rock Hermit")
				pm(s[i].name + ": Furs @ " + this._etMarketPrice(s[i],"furs") + " (" + this._etMarketQuantity(s[i],"furs") + ")",10);
		}
}



// number of days since first run
this._etGetDays = function() {
	var dys=0.0; 
	this.$etDaysStart=2084004.0;
	// output Lave days since induction
	this.$etDays = clock.days; // now
	dys=this.$etDays-this.$etDaysStart;
	dys=dys.toFixed(0);
	return dys;
}


// number of years since first run 
this._etGetYears = function() {
	var yrs=0.0;
	// compute Lave years since induction
	yrs=this._etGetDays();
	yrs=yrs/this.$etLaveYear;
	yrs=yrs.toFixed(3);
	return yrs;
}



// annual time bonus (if any) [TESTING]
this._etGetYBonus = function() {
	var bon=0.0; var yes = false; 
/*	var yrs=this._etGetYears();
	yrs = yrs.toFixed(0);
	// have we completed another year?
	yes = ((yrs % this.$etLaveYear)==0);
	// if so, pay out <grade>% of Guilder's 'net worth'
	var percent = (this.$etGetGrade() / 100) * player.credits;
*/	if (yes) bon = percent; else bon=0.0; 
	return bon;
}



// create G.E.T. Gift to Guild on the F4 Interfaces screen
this._etPrepGift = function(station) {
	station.setInterface("etGift",{
	title: "G.E.T. Gift your Station Profit to the Guild",
	category: "G.E.T.",
	summary: "Make a voluntary gift of your station profit to the Guild, to speed advancement and seal bonds.",
	callback: this._etShowGift.bind(this)
	});	
}


// Present the option to Gift Station profit to the Guild
this._etShowGift = function() {
	
	var parameters = new Object();
	
	parameters.title = "The "+this.$etSystem+" Guild of Elite Traders";
	
	parameters.message = "The "+this.$etSystem+" Guild offers you the opportunity and privilege of advancing in Grade more speedily by magnanimously gifting to the G.E.T. coffers your entire profits gained here in our system - in this case "+formatCredits(this.$etTotProfit/10, true, true)+". \n\n ";

	parameters.message += this.$etBro+" and friend, you will honour and distinguish both the Guild and yourself by rendering this further contribution to G.E.T. beneficence and hegemony... You will be assured of special welcome and expeditious service in every Guild House throughout the Eight Charts. Of this your Gift, Grand Master Exoloön will learn.";
	
	parameters.choicesKey = "etGiftChoices";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		var pc = player.commsMessage;
		var pcm= player.consoleMessage;
		if (choice === "1_YES")  {
			if (!this.$etGifted) {
				if (this.$etTotProfit>0) this.$etGiftCount+=1;
				this.$etGift = this.$etTotProfit;
				this.$etGifts+=this.$etGift;
				// note previous grade here
				this.$etLastGrade=this._etGetGrade();
				this.$etDonations+=this.$etGift;
				this.$etGifted = true;
				// grant 3-point ship enhancement
				this._etEnhanceShip(3);
				// deduct gift from player's credits
				// donation is decicredits, so convert
				player.credits -= this.$etGift/10; 
				if (this.$etGift>0) {
					pc(this.$etBro+", we thank you profusely for your munificence!");
					pc("Your speedy advancement is secure!");
					pcm(this.$etBro+", we grant you a 3-point ship enhancement.");
				} else pc("Blessings, "+this.$etBro);
			} else pc("Please give to G.E.T. at your next port of call!");
			// update Manifest
			this._etShowStatus();
		}
	}
}


	
// create G.E.T. Best Trade Resetter on the F4 Interfaces screen
this._etPrepResetter = function(station) {
	station.setInterface("etResetter",{
	title: "G.E.T. Best Trade Resetter",
	category: "G.E.T.",
	summary: "Reset your Best Trade to the profit gained in this system.",
	callback: this._etShowResetter.bind(this)
	});	
}


// Present the option to reset Best Trade to the profit made here
this._etShowResetter = function() {
	
	var parameters = new Object();
	
	parameters.title = "The "+this.$etSystem+" Guild of Elite Traders";
	
	parameters.message = "The "+this.$etSystem+" Guild of Elite Traders offers you the opportunity to reset your Best Trade, as displayed on your ship's Manifest screen, to the profit you have just gained here in our system - in this case "+formatCredits(this.$etTotProfit/10, true, true)+". \n\n ";

	parameters.message += "In fact you would honour us by doing so...";
	
	parameters.choicesKey = "etResetMaxTradeChoices";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  {
			this.$etMaxTrade=this.$etTotProfit;
			this.$etMaxTSystem=this.$etSystem;		
			this.$etMaxTGoods=this.$etCommodities;		
			// the ship we maxed it in
			var p=player.ship;
			this.$etMaxTShip = p.shipClassName;
			this.$etMaxTShipName = p.shipUniqueName;
			this.$etMaxTShipTC = p.cargoSpaceCapacity;
			player.commsMessage("Maximum Trade reset. Please check the Manifest.");
			// update Manifest
			this._etShowStatus();
		}
	}
}


// create G.E.T. Master Advisory on the F4 Interfaces screen
this._etPrepAdvisory = function(station) {
	station.setInterface("etAdvisory",{
	title: "G.E.T. Master Advisory",
	category: "G.E.T.",
	summary: "Salutation and advice from the Master of the "+this.$etSystem+" Guild of Elite Traders",
	callback: this._etShowAdvisory.bind(this)
	});	
}


// Salutation and advice from the station Guild Master
this._etShowAdvisory = function() {
	
	var parameters = new Object();
	
	parameters.title = "The "+this.$etSystem+" Guild of Elite Traders";
	
	var grade = this._etGetGrade(), title=this.$etGETTitle[grade], lim=this.$etGETTitle.length;
	var grovel ="", pregrovel="";
	var greet = "The "+this.$etSystem+" Guild of Elite Traders bids their "+this.$etBro+" "+player.name+" a hearty welcome to their Guild Home and trusts ";
	if ((grade>=5) && (grade<11)) { greet = title + ", you honour our Guild Home by your visit! If only we had been better prepared for your arrival... " + this.$etSystem + " G.E.T. nevertheless hopes ";
	grovel = "Anything you might need, Master, they are here to serve you."; }
	if ((grade>10)) { greet = title + "! your worshipful presence humbles our poor and wretched Guild Home, yet your visit ennobles us! If only we had been informed that your Honour would be arriving... " + this.$etSystem + " G.E.T. nevertheless prays ";
	grovel = "Anything, anything you require, Exalted One, they are here to serve, as are we all."; }
	
	parameters.message = greet + " this sojourn among us will be advantageous... Trade well! May the GETTING exceed the Taking! \n\n";
	
	// G.E.T. contact (Assessor)
	parameters.message += "Master " + this.$etContact + " is your Assessor and contact for your stopover. "+grovel+" \n\n";
	
	// Planets with stations
	var plan = "", p=system.planets, sta="", s=system.stations;
	if ((p.length>1) && (this.$etPoints>5)) { 
		for (var i=0; i<p.length; i++) {
			if (i>0) plan += p[i].name+" "+this.$etRoman[i+1]+"  ";
			else plan += p[i].name+"  ";
		}
		parameters.message += "Our planets with stations are: "+plan+"\n\n"; 
	
		/*for (i=0; i<s.length; i++) if (s[i].name!="Rock Hermit") sta += s[i].name + "  ";
		parameters.message += "Our stations are: "+sta+"\n\n";*/ 
	
		// prices of system's prime commodities, plus quantity
		var ind = (system.economy<4);
		if (ind) {
			for (i=0; i<s.length; i++) { 
				if (s[i].name!="Rock Hermit") { 
					parameters.message += "Computers at our "+ s[i].name + " cost " + this._etMarketPrice(s[i],"computers") + " (" + this._etMarketQuantity(s[i],"computers") + ") \n";
					parameters.message += "Luxuries at our "+ s[i].name + " cost " + this._etMarketPrice(s[i],"luxuries") + " (" + this._etMarketQuantity(s[i],"luxuries") + ") \n\n";
				}
			}
		} else {
			for (i=0; i<s.length; i++) { 
				if (s[i].name!="Rock Hermit") {
					parameters.message += "Furs at our "+ s[i].name + " cost " + this._etMarketPrice(s[i],"furs") + " (" + this._etMarketQuantity(s[i],"furs") + ") \n";
					parameters.message += "Liquors at our "+ s[i].name + " cost " + this._etMarketPrice(s[i],"liquor_wines") + " (" + this._etMarketQuantity(s[i],"liquor_wines") + ") \n\n";
				}
			}
		}
		parameters.message += "\n";
	}
	
	if (grade<6)  parameters.message += "To business, "+this.$etBro+"... "; else
	if (grade<11) parameters.message += "To business, then, Friend and "+this.$etBro+"... "; else
	if (grade<lim) parameters.message += "To business, then, o Perfected "+this.$etBro+" and - dare we hope? - Friend... ";
	
	if (this.$etPoints<=6) {
		var p = player.ship;
		var sname = p.shipUniqueName; 
		var sclass = p.shipClassName;

		parameters.message += "You may note with irony that G.E.T. cares little whether Galcop deems your goods illegal... We have small truck with that legislative body. With us, your record is always clean, and all trades legitimate in our eyes.  \n\n"

		parameters.message += "Words of advice are never amiss, you'll agree? ";
		
		parameters.message += "One abiding Rule governs our Order: Trade well, refrain from combat, aid your Brothers. Above all, do not kill. ";
	
		parameters.message += "Remember it - advance in Grade and wealth. Ignore it, and risk our silence. Then only Penance will bring you back. \n\n";
		
		if (this.$etStrict) var strctMsg = "Above Grade 1, "; else strctMsg="";
		parameters.message += "Your craft has a 'weapons offline' switch: "+strctMsg+"use it after witch and watch threats fly by with J-drive engaged. G.E.T. provides priority docking to all Brothers; in the shipyard, our Master mechs and techs are unrivalled. Your "+sclass+" will flourish! ";
	} 
	else if (!this.$etMarketObserver) 
		parameters.message += "As it forever has been, the Market Observer and Market Inquirer of Fra Spara are almost de rigueur. Do not exit a space-dock without these! Seek a Torus to Sun Drive and our Advanced Space Compass once you have your Large Cargo Bay and Goods Containers, obtaining which is now your prime concern. \n \n";

	parameters.choicesKey = "etAcknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("Luck in the Markets!");
	}
}


// Vow of Good Brotherhood
this._etPrepVow = function(station) {
	station.setInterface("etVow",{
	title: "G.E.T. Vow of Good Brotherhood",
	category: "G.E.T.",
	summary: "Make a Vow of Good Brotherhood to the Master of the "+this.$etSystem+" Guild of Elite Traders",
	callback: this._etShowVow.bind(this)
	});	
}


// Present the option to make a Vow of Good Brotherhood
this._etShowVow = function() {
	
	var parameters = new Object();
	
	parameters.title = "The "+this.$etSystem+" Guild of Elite Traders";
	
	parameters.message = "We observed with sadness your straying from the Path of Good Brotherhood. You have killed - not once, but multiple times. Yet we understand your urges and the weakness of the newly inducted. For this reason, the "+this.$etSystem+" Guild of Elite Traders offers you the opportunity to mend errant ways... \n\n ";
	
	parameters.message += "The Masters of the Guild are prepared to reinstate you as a full "+this.$etBro+" and restore all privileges of the G.E.T., indeed to forget your infractions, provided you demonstrate self-discipline and, above all, mercy in your future conduct on the space-lanes.\n\n ";
	
	parameters.message += "Remember the Rule: Do not kill. It is our only Rule. We do not ask why you broke it, but do demand that you respect and live by it. \n\n ";
	
	parameters.message += "Commander "+player.name+", are you prepared now to renew your Vow of Good Brotherhood with the Guild? \n\n ";

	this.$etVowing = true;
	parameters.choicesKey = "etVowChoices";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  {
			// reinstate Brother's privileges
			this.$etIsBellig = false;
			this.$etBeenBellig = false;
			this.$etKillCount = 0;
			this.$etVowCount ++;
			player.ship.bounty = 0;
			player.consoleMessage("Then all is forgiven and we welcome you back.",5);
		} else player.consoleMessage("Then our backs must remain turned. Fare well.",5);
	}
}


// G.E.T. ship condition and status report
this._etPrepShipStatus = function(station) {
	station.setInterface("etShipStatus",{
	title: "G.E.T. Ship Status Report",
	category: "G.E.T.",
	summary: "The current state of your G.E.T. ship enhancements.",
	callback: this._etShowShipStatus.bind(this)
	});	
}


// Display status of G.E.T. ship enhancements
this._etShowShipStatus = function() {
	var p = player.ship;
	var sname = p.shipUniqueName; 
	var sclass = p.shipClassName;
	
	if ((sname!=null) && (sname!="")) sname = " '"+sname+"' ";
	
	var parameters = new Object();
	
	parameters.title = "The "+this.$etSystem+" G.E.T. Shipyard";
	
	parameters.message = "The "+this.$etSystem+" Guild of Elite Traders bids you welcome to our shipyard and hopes that our services to your fine "+sclass+sname+" meet with approval. Since your induction, technical enhancements to her systems have included: \n\n";

	parameters.message += "Nominal speed: "+this.$etInitialSpeed+"  -->>  Current speed: "+p.maxSpeed+" \n\n";
	
	parameters.message += "Nominal thrust: "+this.$etInitialThrust+"  -->>  Current thrust: "+p.maxThrust+" \n\n";
	
	parameters.message += "Nominal shields: "+this.$etInitialShields+"  -->>  Current shields: "+p.maxForwardShield+" \n\n";
	
	parameters.message += "Nominal energy: "+this.$etInitialEnergy+"  -->>  Current energy: "+p.maxEnergy+" \n\n";
		
	parameters.message += "Nominal recharge: "+this.$etInitialERecharge.toFixed(2)+"  -->>  Current recharge: "+p.energyRechargeRate.toFixed(2)+" \n\n";

	parameters.choicesKey = "etAcknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("Be safe in the Lane!");
	}
}


// price of a good at a given station, in cr
this._etMarketPrice = function(sta, good) {
	var price=0.0, mar=sta.market;
	price = mar[good].price/10;
	return price.toFixed(1);
}


// quantity of a good at a given station
this._etMarketQuantity = function(sta, good) {
	var quant=0, mar=sta.market;
	quant = mar[good].quantity;
	return quant;
}


/* Note: this helper function is from phkb's Equipment Storage OXP */
// returns the player's target system (1.80) or the next jump to their target system (1.82+)
this._TargetSystem = function _TargetSystem() {
	if (player.ship.hasOwnProperty("nextSystem")) return player.ship.nextSystem;

	var target = player.ship.targetSystem;

	if (oolite.compareVersion("1.81") < 0 && player.ship.hasEquipmentProviding("EQ_ADVANCED_NAVIGATIONAL_ARRAY") === true) {
		// in 1.81 or greater, the target system could be more than 7 ly away. It becomes, essentially, the final destination.
		// there could be multiple interim stop points between the current system and the target system.
		// the only way to get this info is to recreate a route using the same logic as entered on the ANA, and pick item 1
		// from the list. That should be the next destination in the list.
		if (system.ID === -1) {
			var myRoute = System.infoForSystem(galaxyNumber, this._lastSource).routeToSystem(System.infoForSystem(galaxyNumber, target), player.ship.routeMode);
		} else {
			var myRoute = System.infoForSystem(galaxyNumber, global.system.ID).routeToSystem(System.infoForSystem(galaxyNumber, target), player.ship.routeMode);
		}
		if (myRoute && myRoute.route.length >= 1) {
			target = myRoute.route[1];
		}
	}

	return target;
}



// create G.E.T. 'Buber's Beats' page 
this._etPrepBeats = function(station) {
	station.setInterface("etBeats",{
	title: "G.E.T. Milk or Cream? - Buber's Beats",
	category: "G.E.T.",
	summary: "Solid examples and advice from a favoured Brother with our exalted Grand Master's endorsement.",
	callback: this._etShowBeats.bind(this)
	});	
}


// Buber's Beats - walkthrough and advice
this._etShowBeats = function() {
	
	var parameters = new Object();
	
	parameters.title = "The "+this.$etSystem+" Guild of Elite Traders";
	
	parameters.message = "Your Friend and Brother, Master Traveller Fens Buber, offers you these notes with our exalted Grand Master's approval: \n\n";

	parameters.message += "Talk in the Halls of Inera has circled around what most might aid and further an initiate's progress. The Masters' consensus was 'solid guidance'. So I here offer four starter Milk Runs to low-grade commanders leaving Lave with 1000 cr. \n\n";

	parameters.message += "Spaceway L1/L2, Sector One, Galaxy One \n";
	parameters.message += "----------------------------------------------------------- \n\n";

	parameters.message += "0. (Lave-->Zaonce-->Isinor-->) \n";
	parameters.message += "1. Qutiri-->Isinor-->Ensoreus-->Ararus \n";
	parameters.message += "2. Zarece-->Isence \n";
	parameters.message += "3. Xexedi-->Laenin-->Lerelace \n";
	parameters.message += "4. Razaar-->Zadies-->Anarlaqu-->Vetitice \n\n";

	parameters.message += "Of these 4 remunerative runs, Zarece-->Isence is without doubt 'the cream'. \n\n";

	parameters.message += "Repeat and vary at will, or make the whole tour of these 13 systems. Buy Computers (+luxuries) in Rich Industrials and Furs (+liquor-wines) in Poor Agriculturals. \n\n";

	/* There seems to be no way of scrolling lengthy text on the F4 Interfaces pages, so the following had to be cut: 
	
	"Trade well and always check the Master's Advisory on docking! \n\n"   
		
	parameters.message += "By Qutiri, there'll be enough credits for a Large Cargo Bay, and after hitting Xexedi and plying this my favoured triple beat, 10 or 20 ton Goods Containers will start gracing your missile pylons. \n\n";*/

	/*
	parameters.message += "(if Elite Trader is coupled with FE Ships Player, the Cobra III FE can end up with a total capacity of 110 or 150 TC, depending which container tonnage was fitted). \n\n";

	parameters.message += "Enhance immersion by adding the OXPs Extra Planets, Stations for Extra Planets, Torus to Sun Drive, Market Inquirer, and Market Observer. Picking and choosing among the several stations and outposts insystem, finding lucrative deals among them, and maximizing profits for rapid advancement then becomes not only easier and more enjoyable, but also an interesting challenge. \n\n";
	*/
	
	/*parameters.message += "How does one 'leave Lave with 1000 credits'? - Why, strip and then sell your first Cobra! Exchange it for a 'standard customer model/clone' at the lowest price you can find; then sell its laser and 'unmount all pylon-mounted weapons'. Nearly 1000 cr is now yours to buy furs and alchoholic beverages. Head straight out for Zaonce and Isinor, buying cheap and selling dear as you go. \n\n";*/

	
	parameters.choicesKey = "etAcknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("Trade well and wisely, "+this.$etBro+"!");
	}
}



// Prepare Gender request
this._etPrepGender = function(station) {
	station.setInterface("etGender",{
	title: "G.E.T. Your gender, gentle Guilder?",
	category: "G.E.T.",
	summary: "The Guild Master requests to know whether you are female, male, or bi-gendered.",
	callback: this._etShowGender.bind(this)
	});	
}


// Present the option to impart your gender
this._etShowGender = function() {
	
	var parameters = new Object();
	
	parameters.title = "The "+this.$etSystem+" Guild of Elite Traders";
	
	parameters.message = "Profuse and embarrassed apologies, but the Guild Master of "+this.$etSystem+" has been unable to determine your gender... Would you perhaps be willing to impart it to me, his assistant, so that no faux pas in future protocol will occur? \n\n ";
	
	parameters.message += "If female, we shall be pleased and honoured to call you 'Sister'; if male - 'Brother'; if bi-, tri-, or null-gendered - 'Sibling'... or simply continue with 'Guilder' if you prefer. \n ";
	
	parameters.choicesKey = "etGenderChoices";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_FEMALE") this.$etBro="Sister"; else
		if (choice === "2_MALE") this.$etBro="Brother"; else
		if ((choice === "3_BOTH") || (choice== "4_NULL")) this.$etBro="Sibling"; else
			this.$etBro = "Guilder";
		if (this.$etBro==="Sibling") player.consoleMessage("Thank you. Then you shall be our 'Sibling'.",7); else player.consoleMessage("Thank you "+this.$etBro+". We will remember it.",7);
		this.$etGendered=true;
	}
}


